-- Skript zum Erstellen einer generischen Log-Tabelle
-- Als Benutzer SCOTT ausführen

-- Erzeugung der Objekttypen
create or replace
type log_arg as object(
  col varchar2(32),
  val varchar2(4000 char));
/

create or replace
type log_args as table of log_arg;
/

-- Log-Sequenz
create sequence log_seq;

-- zentrale Log-Tabelle
create table log_historie (
  id number,
  wer varchar2(50 char) not null,
  wann date not null,
  tabelle varchar2(32 char) not null,
  aktivitaet char(1 char) not null,
  row_id number not null,
  daten log_args,
  constraint log_historie_pk primary key (id)
)
nested table daten store as log_daten
return as value;

-- Indizierung zur schnellen Suche nach Änderungen durch einen bestimmten Benutzer
-- oder Änderungen an einer bestimmten Tabelle
create index idx_log_historie_wer on log_historie(wer);
create index idx_log_historie_tabelle on log_historie(tabelle);

-- Einfacher Trigger zum Umsetzen des Loggings
create or replace
trigger ariud_emp
after insert or update or delete on emp
for each row
declare
  aktion char(1);
begin
  if inserting then
    aktion := 'I';
  elsif updating then
    aktion := 'U';
  else
    aktion := 'D';
  end if;
  insert into log_historie(id, wer, wann, tabelle, aktivitaet, row_id, daten)
  values (log_seq.nextval, user, systimestamp, 'EMP', aktion, :new.empno, 
          log_args(
            log_arg('ENAME', :new.ename),
            log_arg('JOB', :new.job),
            log_arg('MGR', :new.mgr),
            log_arg('HIREDATE', to_char(:new.hiredate, 'dd.mm.yyyy')),
            log_arg('SAL', to_char(:new.sal)),
            log_arg('COMM', to_char(:new.comm)),
            log_arg('DEPTNO', to_char(:new.deptno))
          )
        );
end;
/

update emp
   set ename = ename;
   
-- eine View zeigt die Daten des Loggings:
select l.wer, l.wann, l.tabelle, l.aktivitaet, l.row_id, d.*
  from log_historie l,
       table(l.daten) d;
       
-- oder auch pivotiert, dann aber nur noch für die konkrete Tabelle
select l.wer, l.wann, l.tabelle, l.aktivitaet, l.row_id, 
       max(decode(d.col, 'ENAME', d.val)) ename, 
       max(decode(d.col, 'JOB', d.val)) job, 
       max(decode(d.col, 'MGR', d.val)) mgr, 
       max(decode(d.col, 'HIREDATE', d.val)) hiredate, 
       max(decode(d.col, 'SAL', d.val)) sal, 
       max(decode(d.col, 'COMM', d.val)) comm,
       max(decode(d.col, 'DEPTNO', d.val)) deptno
  from log_historie l,
       table(l.daten) d
 group by l.wer, l.wann, l.tabelle, l.aktivitaet, l.row_id;
 
-- Pivotierung mit der pivot-Klausel misslingt allerdings:
select l.wer, l.wann, l.tabelle, l.aktivitaet, l.row_id, d.*
  from log_historie l,
       table(l.daten) d
 pivot (d.val for d.col in ('ENAME', 'JOB', 'MGR', 'HIREDATE', 'SAL', 'COMM', 'DEPTNO'));

